/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.spawnercontrol.controlledspawner;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladysnake.spawnercontrol.config.MSCConfig;
import ladysnake.spawnercontrol.config.SpawnerConfig;
import ladysnake.spawnercontrol.controlledspawner.IControllableSpawner;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityControllableSpawner {
    @CapabilityInject(value=IControllableSpawner.class)
    public static Capability<IControllableSpawner> CAPABILITY_SPAWNER;
    public static final ResourceLocation CAPABILITY_KEY;

    public static IControllableSpawner getHandler(TileEntityMobSpawner entity) {
        return (IControllableSpawner)Objects.requireNonNull(entity.getCapability(CAPABILITY_SPAWNER, null));
    }

    static {
        CAPABILITY_KEY = new ResourceLocation("spawnercontrol", "controllable_spawner_cap");
    }

    public static class Storage
    implements Capability.IStorage<IControllableSpawner> {
        @Nullable
        public NBTBase writeNBT(Capability<IControllableSpawner> capability, IControllableSpawner instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("SpawnedMobsCount", instance.getSpawnedMobsCount());
            return nbt;
        }

        public void readNBT(Capability<IControllableSpawner> capability, IControllableSpawner instance, EnumFacing side, NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                instance.setSpawnedMobsCount(((NBTTagCompound)nbt).func_74762_e("SpawnedMobsCount"));
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        final IControllableSpawner instance;

        public Provider(TileEntityMobSpawner spawner) {
            this.instance = new DefaultControllableSpawner(spawner);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY_SPAWNER;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CAPABILITY_SPAWNER ? CAPABILITY_SPAWNER.cast((Object)this.instance) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)CAPABILITY_SPAWNER.getStorage().writeNBT(CAPABILITY_SPAWNER, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            CAPABILITY_SPAWNER.getStorage().readNBT(CAPABILITY_SPAWNER, (Object)this.instance, null, (NBTBase)nbt);
        }
    }

    public static class DefaultControllableSpawner
    implements IControllableSpawner {
        private final TileEntityMobSpawner spawner;
        private int spawnedMobsCount;

        public DefaultControllableSpawner() {
            this(null);
        }

        DefaultControllableSpawner(TileEntityMobSpawner spawner) {
            this.spawner = spawner;
        }

        @Override
        public void setSpawnedMobsCount(int mobCount) {
            this.spawnedMobsCount = mobCount;
        }

        @Override
        public boolean incrementSpawnedMobsCount() {
            SpawnerConfig cfg = this.getConfig();
            if (++this.spawnedMobsCount >= cfg.mobThreshold) {
                if (cfg.breakSpawner) {
                    this.spawner.func_145831_w().func_175698_g(this.spawner.func_174877_v());
                }
                return true;
            }
            this.adjustDelayAfterSpawn(this.spawner.func_145881_a(), cfg.spawnRateModifier);
            return false;
        }

        protected void adjustDelayAfterSpawn(MobSpawnerBaseLogic spawnerBaseLogic, double spawnRateModifier) {
            spawnerBaseLogic.field_98283_g = (int)((double)spawnerBaseLogic.field_98283_g * spawnRateModifier);
            spawnerBaseLogic.field_98293_h = (int)((double)spawnerBaseLogic.field_98293_h * spawnRateModifier);
        }

        @Override
        public int getSpawnedMobsCount() {
            return this.spawnedMobsCount;
        }

        @Override
        public boolean canSpawn() {
            return this.spawnedMobsCount < this.getConfig().mobThreshold;
        }

        @Override
        @Nonnull
        public SpawnerConfig getConfig() {
            return MSCConfig.vanillaSpawnerConfig;
        }
    }
}

